const express = require('express');
const router = express.Router();
const db = require('../db');

// ✅ Get KYC status by phone number
router.get('/:phone', (req, res) => {
  const { phone } = req.params;

  if (!phone) {
    return res.status(400).json({ error: true, message: 'Phone number is required' });
  }

  const query = 'SELECT id, phone, full_name, status FROM kyc_details WHERE phone = ?';

  db.query(query, [phone], (err, results) => {
    if (err) {
      console.error('Database Error:', err);
      return res.status(500).json({
        error: true,
        message: err.sqlMessage || err.message,
        code: err.code,
      });
    }

    if (results.length === 0) {
      return res.status(404).json({
        error: true,
        message: 'No KYC record found for this phone number',
      });
    }

    res.status(200).json({
      error: false,
      message: 'KYC record found',
      data: results[0],
    });
  });
});

module.exports = router;
