const express = require('express');
const cors = require('cors');
const bodyParser = require('body-parser');
const dotenv = require('dotenv');
dotenv.config();

const app = express();
app.use(cors());
app.use(bodyParser.json());
app.use('/uploads', express.static('uploads'));

// Routes
app.use('/ovira/api/auth', require('./routes/auth'));
app.use('/ovira/api/kyc', require('./routes/kyc'));
app.use('/ovira/api/qr', require('./routes/qr'));
app.use('/ovira/api/withdraw', require('./routes/withdraw'));
app.use('/ovira/api/edit', require('./routes/editprofile'));
app.use('/ovira/api/transaction', require('./routes/transaction'));
app.use('/ovira/api/userlist', require('./routes/userlist'));
app.use('/ovira/api/updatestatus', require('./routes/updatestatus'));
app.use('/ovira/api/checkmobile', require('./routes/checkmobile'));
app.use('/ovira/api/getkycstatus', require('./routes/getkycstatus'));

app.use('/ovira/api/withdraws', require('./routes/withdrawrequests'));
app.use('/ovira/api/withdrawstatus', require('./routes/updatewithdrawstatus'));




// Start Server
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => console.log(`🚀 Server running on port ${PORT}`));
